'
'  This program uses the system bios and low-level DOS calls to
' investigate various aspects (mainly attached equipment) of a computer
' system.
'
'  Declare necessary functions and define REGISTERS variable type for
' interrupt calls.
'
DECLARE FUNCTION BIN$(N AS LONG)
DECLARE FUNCTION DEC%(S AS STRING)
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
'
'  Define register varables and other data to be output based on system
' queries.
'
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,BIT AS INTEGER,ARCH$(2),EBDA$(1)
DIM DISK$(1),MATH$(1),SYST$(3),VID$(1 TO 3),GAME$(1),POINT$(1),MODEM$(1)
DIM BIT0 AS INTEGER,BIT3 AS INTEGER,BYTE AS LONG,EBDAADD AS LONG,FREMRY AS LONG
DIM CMODE AS INTEGER,PSP AS LONG,COM1ADD AS INTEGER,COM2ADD AS INTEGER
DIM LPT1ADD AS INTEGER,LPT2ADD AS INTEGER,LPT3ADD AS INTEGER,NEWMODE AS INTEGER
DIM XMS AS LONG,XMSTOT AS LONG,XMSLOW AS LONG,XMSHI AS LONG,OS AS INTEGER
DIM CLISTI AS INTEGER
DISK$(0)="No disk drive installed" : DISK$(1)="Disk drive installed"
MATH$(0)="No math coprocessor" : MATH$(1)="Math coprocessor installed"
SYST$(0)="16K" : SYST$(1)="32K" : SYST$(2)="48K" : SYST$(3)="64K"
VID$(1)="40 x 25 color" : VID$(2)="80 x 25 color" : VID$(3)="80 x 25 mono"
GAME$(0)="No game adapter detected" : GAME$(1)="Game adapter detected"
POINT$(0)="No pointing device detected" : POINT$(1)="Pointing device detected"
MODEM$(0)="No modem" : MODEM$(1)="Modem installed"
ARCH$(0)="PC bus I/O channel" : ARCH$(1)="Microchannel architecture detected"
ARCH$(2)="Dual bus (Microchannel + ISA)" : EBDA$(0)="EBDA not allocated"
EBDA$(1)="EBDA allocated"
'
'  Get bios date.
'
DEF SEG=&HF000
OS=&HFFF5
BIOSDATE$=""
FOR I=1 TO 8
BIOSDATE$=BIOSDATE$+CHR$(PEEK(OS))
OS=OS+1
NEXT I
'
'  Get current video mode and then put screen into QB standard text mode.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
CMODE=OUTREGS.AX AND &HFF
SCREEN 0
CLS
'
'  Get new bios video mode for later test of whether or not it changed.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEWMODE=OUTREGS.AX AND &HFF
'
'  Don't do anything else unless DOS version is at least 2.
'
INREGS.AX=&H3000
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
DOSVER=OUTREGS.AX AND &HFF
IF DOSVER>1 THEN
'
'  Use interrupt 15 / function C0 to get information about computer model.
' (Some of the information returned from this and other interrupt calls
' needs to be extracted at the bit level.  Function BIN$ is used to
' convert numbers to binary for this purpose.  The MID$ function is then
' used to extract the bits.)
'
INREGS.AX=&HC000
CALL INTERRUPTX(&H15,INREGS,OUTREGS)
'
'  If AH or CF aren't 0, warn user about possible inapplicability of this
' program.
'
BYTE=CLNG(OUTREGS.FLAGS)
IF INT(OUTREGS.AX/256+.001)<>0 OR MID$(BIN$(BYTE),16,1)="1" THEN
PRINT "  This program may give some erroneous results for this computer.  (Int";
PRINT "errupt"
PRINT "15 / function C0 either didn't return a 0 in AH or else it set the carr";
PRINT "y flag."
PRINT "If the following output seems consistent with what you know about your ";
PRINT "computer,"
PRINT "then simply disregard this warning.)"
PRINT
PRINT "Press a key to continue..."
5 IF INKEY$="" THEN GOTO 5
CLS
END IF
DEF SEG=OUTREGS.ES
OS=OUTREGS.BX
MODEL=PEEK(OS+2)
SUBMOD=PEEK(OS+3)
REVIS=PEEK(OS+4)
BYTE=CLNG(PEEK(OS+5))
B$=BIN$(BYTE)
DEF SEG
IF MODEL=&HFA THEN
COMP$="PS/2"
IF SUBMOD=0 THEN
COMP$=COMP$+" Model 30"
IF REVIS=0 THEN COMP$=COMP$+" (8 MHz 8086)
ELSEIF SUBMOD=1 THEN
COMP$=COMP$+" Model 25/25L (8 MHz 8086)
END IF
IF SUBMOD=&H30 THEN COMP$="IBM Restaurant Terminal"
IF SUBMOD=&H4E THEN COMP$="Olivetti M111"
IF SUBMOD=&HFE THEN COMP$="IBM PCradio 9075"
ELSEIF MODEL=&HF8 THEN
COMP$="PS/2"
IF SUBMOD=0 THEN COMP$=COMP$+" Model 80/75 (386+)"
IF SUBMOD=1 THEN COMP$=COMP$+" Model 80 (20 MHz 386)"
IF SUBMOD=2 THEN COMP$=COMP$+" Model 55-5571"
IF SUBMOD=4 THEN
COMP$=COMP$+" Model 70"
IF REVIS=0 THEN COMP$=COMP$+" (20 MHZ 386DX)
IF REVIS=2 OR REVIS=3 THEN COMP$=COMP$+" (20 MHz)"
ELSEIF SUBMOD=7 THEN
IF REVIS=0 OR REVIS=2 THEN COMP$="IBM PC 7561/2"
IF REVIS=1 OR REVIS=3 THEN COMP$=COMP$+" Model 55-5551"
ELSEIF SUBMOD=9 THEN
COMP$=COMP$+" Model 70"
IF REVIS=0 THEN COMP$=COMP$+" (16 MHz 386DX)"
IF REVIS=4 THEN COMP$=COMP$+" (16 MHz 386)"
ELSEIF SUBMOD=&HB THEN
COMP$=COMP$+ "Model P70"
IF REVIS=0 THEN COMP$=COMP$+" (8573-121)"
ELSEIF SUBMOD=&H25 THEN
IF REVIS=0 THEN COMP$=COMP$+" Model 57 SLC"
IF REVIS=6 THEN COMP$=COMP$+" Model M57 (20 MHz 386SLC)"
ELSEIF SUBMOD=&H26 THEN
COMP$=COMP$+" Model 57 SX"
IF REVIS=1 OR REVIS=2 THEN COMP$=COMP$+" (20 MHz 386SX)"
ELSEIF SUBMOD=&H50 THEN
COMP$=COMP$+" Model P70"
IF REVIS=0 THEN COMP$=COMP$+" (8573)"
IF REVIS=1 THEN COMP$=COMP$+" (8570-031)"
ELSEIF SUBMOD=&H80 THEN
COMP$=COMP$+" Model 80 (25 MHz 386)"
IF REVIS=1 THEN COMP$="PS/2 Model 80-A21 (25 MHz 386)"
END IF
IF SUBMOD=5 THEN COMP$="IBM PC 7568
IF SUBMOD=6 THEN COMP$=COMP$+" Model 55-5571"
IF SUBMOD=&HC THEN COMP$=COMP$+" Model 55SX (16 MHz 386SX)
IF SUBMOD=&HD THEN COMP$=COMP$+" Model 70 (386/486 25 Mhz)"
IF SUBMOD=&HE THEN COMP$="PS/1 486SX"
IF SUBMOD=&HF THEN COMP$="PS/1 486DX"
IF SUBMOD=&H10 THEN COMP$=COMP$+" 55-5551"
IF SUBMOD=&H11 OR SUBMOD=&H13 OR SUBMOD=&H15 THEN COMP$=COMP$+" Model 90 XP"
IF SUBMOD=&H17 OR SUBMOD=&H29 OR SUBMOD=&H2B THEN COMP$=COMP$+" Model 90 XP"
IF SUBMOD=&H2D OR SUBMOD=&H2F OR SUBMOD=&H37 THEN COMP$=COMP$+" Model 90 XP"
IF SUBMOD=&H3F OR SUBMOD=&H45 OR SUBMOD=&H47 THEN COMP$=COMP$+" Model 90 XP"
IF SUBMOD=&H57 OR SUBMOD=&H59 OR SUBMOD=&H5B THEN COMP$=COMP$+" Model 90 XP"
IF SUBMOD=&H12 OR SUBMOD=&H1A OR SUBMOD=&H28 THEN COMP$=COMP$+" Model 95 XP"
IF SUBMOD=&H2A OR SUBMOD=&H2C OR SUBMOD=&H2E THEN COMP$=COMP$+" Model 95 XP"
IF SUBMOD=&H36 OR SUBMOD=&H39 OR SUBMOD=&H40 THEN COMP$=COMP$+" Model 95 XP"
IF SUBMOD=&H46 OR SUBMOD=&H58 OR SUBMOD=&H5A THEN COMP$=COMP$+" Model 95 XP"
IF SUBMOD=&H5C THEN COMP$=COMP$+" Model 95 XP"
IF SUBMOD=&H14 THEN COMP$=COMP$+" Model 90-AK9"
IF SUBMOD=&H16 THEN COMP$=COMP$+" Model 90-AKD"
IF SUBMOD=&H19 THEN COMP$=COMP$+" Model 35"
IF SUBMOD=&H1B THEN COMP$=COMP$+" Model 70 486 (25 MHz 386+)"
IF SUBMOD=&H1C THEN COMP$=COMP$+" Model 65-121/65 SX"
IF SUBMOD=&H1E THEN COMP$=COMP$+" Model 55LS (16 MHz 386SX)"
IF SUBMOD=&H23 THEN COMP$=COMP$+" Model L40 SX"
IF SUBMOD=&H30 THEN COMP$="PS/1 Model 2121 (16 MHz 386SX)"
IF SUBMOD=&H33 THEN COMP$=COMP$+" Model 30-386"
IF SUBMOD=&H34 THEN COMP$=COMP$+" Model 25-386"
IF SUBMOD=&H38 THEN COMP$=COMP$+" Model 57"
IF SUBMOD=&H41 THEN COMP$=COMP$+" Model 77"
IF SUBMOD=&H52 THEN COMP$=COMP$+" Model P75 (33 MHz 486)"
IF SUBMOD=&H56 THEN COMP$=COMP$+" Model CL57 SX"
IF SUBMOD=&H5D THEN COMP$=COMP$+" Model N51 SLC"
IF SUBMOD=&H5E THEN COMP$="IBM ThinkPad 700"
IF SUBMOD=&H61 THEN COMP$="Olivetti P500"
IF SUBMOD=&H62 THEN COMP$="Olivetti P800"
IF SUBMOD=&H81 THEN COMP$=COMP$+" Model 55-5502"
IF SUBMOD=&H87 THEN COMP$=COMP$+" Model N33SX"
IF SUBMOD=&H88 THEN COMP$=COMP$+" Model 55-5530T"
IF SUBMOD=&H97 THEN COMP$=COMP$+" Model 55 Note N23SX"
IF SUBMOD=&H99 THEN COMP$=COMP$+" Model N51 SX"
IF SUBMOD=&HF2 THEN COMP$="Reply Model 32"
IF SUBMOD=&HF6 THEN COMP$="Memorex Telex"
IF SUBMOD=&HFD THEN COMP$="IBM Processor Complex/with VPD"
ELSEIF MODEL=&HFF THEN
COMP$="PC"
IF SUBMOD=0 THEN COMP$="Tandy 1000SL"
IF SUBMOD=1 THEN COMP$="Tandy 1000TL"
IF SUBMOD=&H46 THEN COMP$="Olivetti M15"
ELSEIF MODEL=&HFE THEN
COMP$="PC XT"
IF SUBMOD=&H43 THEN COMP$="Olivetti M240"
IF SUBMOD=&HA6 THEN COMP$="Quadram Quad386"
ELSEIF MODEL=&HFB THEN
COMP$="PC XT"
IF SUBMOD=&H4C THEN COMP$="Olivetti M200"
ELSEIF MODEL=&HFD THEN
COMP$="PCjr"
ELSEIF MODEL=&HFC THEN
COMP$="AT / PC XT 286 (or higher)"
IF SUBMOD=4 THEN
COMP$="PS/2"
IF REVIS=0 OR REVIS=1 THEN COMP$=COMP$+" Model 50"
IF REVIS=2 THEN COMP$=COMP$+" Model 50/50Z"
IF REVIS=3 OR REVIS=4 THEN COMP$=COMP$+" Model 50Z"
ELSEIF SUBMODEL=8 THEN
COMP$="PS/2"
IF REVIS=0 THEN COMP$=COMP$+" Model 25/286"
ELSEIF SUBMOD=5 THEN
COMP$="PS/2"
IF REVIS=0 THEN COMP$=COMP$+" Model 60 (10 MHz 286)"
ELSEIF SUBMOD=6 THEN
COMP$="IBM 7552"
IF REVIS=0 THEN COMP$=COMP$+"-140"
IF REVIS=1 THEN COMP$=COMP$+"-540"
ELSEIF SUBMOD=&H81 THEN
IF REVIS=0 THEN COMP$="Phoenix 386 BIOS v1.10 10a"
IF REVIS=1 THEN COMP$="OEM machine"
ELSEIF SUBMOD=&H94 THEN
COMP$="Zenith"
IF REVIS=0 THEN COMP$=COMP$+" 386"
END IF
IF SUBMOD=9 THEN COMP$="PS/2 Model 25/30 (10 MHz 286)"
IF SUBMOD=&HB THEN COMP$="PS/1"
IF SUBMOD=&H20 THEN COMP$="Compaq Prolinea"
IF SUBMOD=&H30 OR SUBMOD=&H31 OR SUBMOD=&H33 THEN COMP$="Epson"
IF SUBMOD=&H42 THEN COMP$="Olivetti M280"
IF SUBMOD=&H45 THEN COMP$="Olivetti M380"
IF SUBMOD=&H48 THEN COMP$="Olivetti M290"
IF SUBMOD=&H4F THEN COMP$="Olivetti M250"
IF SUBMOD=&H50 THEN COMP$="Olivetti M380"
IF SUBMOD=&H51 THEN COMP$="Olivetti PCS286"
IF SUBMOD=&H52 THEN COMP$="Olivetti M300"
IF SUBMOD=&H82 THEN COMP$="OEM machine"
ELSEIF MODEL=&HE4 THEN
COMP$="Triumph Adler PC/XT"
ELSEIF MODEL=&HE1 THEN
COMP$="Unknown"
IF SUBMOD=0 AND REVIS=0 THEN COMP$="PS/2 Model 55-5530 Laptop"
ELSEIF MODEL=&HD9 THEN
COMP$="Peacock XT"
ELSEIF MODEL=&H9A THEN
COMP$="Compaq XT/Compaq Plus
ELSEIF MODEL=&H30 THEN
COMP$="Sperry PC"
ELSEIF MODEL=&H2D THEN
COMP$="Compaq PC/Compaq Deskpro"
ELSEIF MODEL=&HF9 THEN
COMP$="PC Convertible"
ELSE
COMP$="Unknown"
END IF
PRINT COMP$;" computer model detected  (bios date = ";BIOSDATE$;")"
PRINT
'
'  First four characters of COMP$ are used subsequently as test-string.
'
COMP$=LEFT$(COMP$,4)
BIT0=VAL(MID$(B$,16,1))
BIT=VAL(MID$(B$,15,1)) : IF BIT0=1 THEN BIT=2
PRINT ARCH$(BIT)
PRINT
BIT3=VAL(MID$(B$,14,1))
PRINT EBDA$(BIT3)
PRINT
IF MID$(B$,11,1)="1" THEN PRINT "Real-time clock present" : PRINT
'
'  Interrupt 11 returns a "rudimentary list of equipment attached to the
' computer."
'
CALL INTERRUPTX(&H11,INREGS,OUTREGS)
'
'  Equipment presence is indicated bit by bit and the interpretation of
' the output (in AX) depends on the computer model.
'
BYTE=CLNG(OUTREGS.AX)
B$=BIN$(BYTE)
BIT0=VAL(MID$(B$,16,1))
PRINT DISK$(BIT0)
PRINT
BIT=VAL(MID$(B$,15,1))
PRINT MATH$(BIT)
PRINT
IF COMP$<>"PS/2" THEN
BIT=DEC(MID$(B$,13,2))
PRINT SYST$(BIT);" system ram"
PRINT
ELSE
BIT=VAL(MID$(B$,14,1))
PRINT POINT$(BIT)
PRINT
END IF
BIT=DEC(MID$(B$,11,2))
PRINT VID$(BIT);" video mode (default)"
PRINT
IF BIT0=1 THEN
BIT=DEC(MID$(B$,9,2))+1
PRINT LTRIM$(RTRIM$(STR$(BIT)));" floppy drives installed"
PRINT
END IF
BIT=DEC(MID$(B$,5,3))
PRINT LTRIM$(RTRIM$(STR$(BIT)));" serial cards installed"
'
'  Pause when screen gets full.
'
PRINT
PRINT
PRINT "Press a key to continue...";
10 IF INKEY$="" THEN GOTO 10
PRINT
PRINT
PRINT
IF COMP$<>"PS/2" THEN
BIT=VAL(MID$(B$,4,1))
PRINT GAME$(BIT)
ELSE
BIT=VAL(MID$(B$,3,1))
PRINT MODEM$(BIT)
END IF
PRINT
BIT=DEC(MID$(B$,1,2))
PRINT LTRIM$(RTRIM$(STR$(BIT)));" printer ports installed"
PRINT
'
'  Interrupt 12 returns the amount of standard RAM installed.
'
CALL INTERRUPTX(&H12,INREGS,OUTREGS)
CONMEM=OUTREGS.AX
'
'  The interpretation of interrupt 12's output depends on whether the
' computer is a "PS/2-like" or not.
'
IF BIT3=1 THEN
PRINT LTRIM$(RTRIM$(STR$(CONMEM)));"K conventional memory (not counting EBDA)"
'
'  For "PS/2-like" computers, interrupt 15 / function C1 returns the
' location of the extended bios data area.  This can be used to calculate
' the amount of extended bios memory (on the assumption that it ends at
' the byte before A000h).
'
INREGS.AX=&HC100
CALL INTERRUPTX(&H15,INREGS,OUTREGS)
'
'  If carry flag isn't set, EBDA information is valid.
'
BYTE=CLNG(OUTREGS.FLAGS)
IF MID$(BIN$(BYTE),16,1)="0" THEN
EBDAADD=CLNG(OUTREGS.ES)
IF EBDAADD<0 THEN EBDAADD=EBDAADD+65536&
EBDAMEM=(&HA000&-EBDAADD)/64
PRINT
PRINT LTRIM$(RTRIM$(STR$(EBDAMEM)));"K EBDA memory at ";HEX$(CINT(EBDAADD));
PRINT ":0000"
END IF
ELSE
PRINT LTRIM$(RTRIM$(STR$(CONMEM)));"K conventional memory"
END IF
PRINT
'
'  Interrupt 21 / function 62 returns the segment number specifying the
' bottom of available RAM.  It can be used with the output of interrupt
' 12 to calculate how much free memory is available.
'
INREGS.AX=&H6200
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
PSP=CLNG(OUTREGS.BX) : IF PSP<0 THEN PSP=PSP+65536&
FREMRY=CONMEM*1024&-PSP*16&
PRINT "(";LTRIM$(RTRIM$(STR$(FREMRY)));" bytes free at ";HEX$(CINT(PSP));"h)"
PRINT
'
'  For relevant computer types, interrupt 15 / function 88 returns the
' amount of free extended memory.  The total amount of extended memory
' is stored in CMOS.
'
IF MODEL=&HFC OR (COMP$="PS/2" AND MODEL<>&HFA) THEN
INREGS.AX=&H8800
CALL INTERRUPTX(&H15,INREGS,OUTREGS)
XMS=CLNG(OUTREGS.AX) : IF XMS<0 THEN XMS=XMS+65536&
'
'  Set up machine code to clear/set interrupt flag and clear flag before
' accessing CMOS registers.
'
CLISTI=&HCBFA
DEF SEG=VARSEG(CLISTI)
OS=VARPTR(CLISTI)
CALL ABSOLUTE(OS)
OUT &H70,&H17
XMSLOW=INP(&H71)
OUT &H70,&H18
XMSHI=INP(&H71)
'
'  Set interrupt flag.
'
POKE OS,&HFB
CALL ABSOLUTE(OS)
DEF SEG
XMSTOT=XMSLOW+256&*XMSHI
PRINT LTRIM$(RTRIM$(STR$(XMS)));"K extended memory (above 100,000h) ";
PRINT "available / ";LTRIM$(RTRIM$(STR$(XMSTOT)));"K total"
PRINT
END IF
'
'  Interrupt 2F / function 43 / subfunction 0 indicates the presence of
' XMS driver.
'
INREGS.AX=&H4300
CALL INTERRUPTX(&H2F,INREGS,OUTREGS)
IF (OUTREGS.AX AND &HFF)=&H80 THEN PRINT "XMS driver detected" : PRINT
'
'  Detecting the presence of COM ports is somewhat tricky (if only because
' I'm not totally sure of the best way of doing it).  The following is a
' roundabout way that seems to work.  COM1 and COM2 are detected by seeing
' if nonzero values for their addresses are stored at memory addresses
' 400h and 402h.  (LPT1, LPT2, and LPT3 are detected similarly.)  COM3 and
' and COM4 are detected by using interrupt 14 / function 30 to query their
' status.  If AH is 96 (decimal) or less, the COM port is assumed to
' exist.  (I'm not guarantying that this process is foolproof.)  If COM1
' or COM2 is found, information about its initialization is returned.
'
DEF SEG=0
COM1ADD=PEEK(&H400)+256*PEEK(&H401) : COM2ADD=PEEK(&H402)+256*PEEK(&H403)
LPT1ADD=PEEK(&H408)+256*PEEK(&H409) : LPT2ADD=PEEK(&H40A)+256*PEEK(&H40B)
LPT3ADD=PEEK(&H40C)+256*PEEK(&H40D)
DEF SEG
IF COM1ADD<>0 THEN
CALL UART(COM1ADD,BAUD,PAR$,DBITS,SBITS)
IF DBITS=5 AND SBITS=2 THEN SBITS=1.5
PRINT "COM1 address = ";HEX$(COM1ADD);"h  (";LTRIM$(RTRIM$(STR$(BAUD)));" baud";
PRINT ", ";PAR$;" parity, ";LTRIM$(RTRIM$(STR$(DBITS)));" data bits, ";
PRINT LTRIM$(RTRIM$(STR$(SBITS)));" stop bits)"
PRINT
END IF
IF COM2ADD<>0 THEN
CALL UART(COM2ADD,BAUD,PAR$,DBITS,SBITS)
IF DBITS=5 AND SBITS=2 THEN SBITS=1.5
PRINT "COM2 address = ";HEX$(COM2ADD);"h  (";LTRIM$(RTRIM$(STR$(BAUD)));" baud";
PRINT ", ";PAR$;" parity, ";LTRIM$(RTRIM$(STR$(DBITS)));" data bits, ";
PRINT LTRIM$(RTRIM$(STR$(SBITS)));" stop bits)"
PRINT
END IF
IF LPT1ADD<>0 THEN PRINT "LPT1 address = ";HEX$(LPT1ADD);"h" : PRINT
PRINT
PRINT
PRINT "Press a key to continue...";
20 IF INKEY$="" THEN GOTO 20
PRINT
PRINT
PRINT
IF LPT2ADD<>0 THEN PRINT "LPT2 address = ";HEX$(LPT2ADD);"h" : PRINT
IF LPT3ADD<>0 THEN PRINT "LPT3 address = ";HEX$(LPT3ADD);"h" : PRINT
INREGS.AX=&H300
INREGS.DX=2
CALL INTERRUPTX(&H14,INREGS,OUTREGS)
COM3D=SGN(96-INT(OUTREGS.AX/256+.001))
INREGS.AX=&H300
INREGS.DX=3
CALL INTERRUPTX(&H14,INREGS,OUTREGS)
COM4D=SGN(96-INT(OUTREGS.AX/256+.001))
IF COM3D<0 THEN
CALL UART(&H3E8,BAUD,PAR$,DBITS,SBITS)
IF DBITS=5 AND SBITS=2 THEN SBITS=1.5
PRINT "COM3 detected  (";LTRIM$(RTRIM$(STR$(BAUD)));" baud, ";
PRINT PAR$;" parity, ";LTRIM$(RTRIM$(STR$(DBITS)));" data bits, ";
PRINT LTRIM$(RTRIM$(STR$(SBITS)));" stop bits)"
PRINT
END IF
IF COM4D<0 THEN
CALL UART(&H2E8,BAUD,PAR$,DBITS,SBITS)
IF DBITS=5 AND SBITS=2 THEN SBITS=1.5
PRINT "COM4 detected  (";LTRIM$(RTRIM$(STR$(BAUD)));" baud, ";
PRINT PAR$;" parity, ";LTRIM$(RTRIM$(STR$(DBITS)));" data bits, ";
PRINT LTRIM$(RTRIM$(STR$(SBITS)));" stop bits)"
PRINT
END IF
'
'  For non-PS/2 computers, look for rodent.  Detection of where mouse is
' attached is rigorous only if a "Mouse Systems" driver is loaded.  Even
' then, all that can be ascertained from querying the driver is whether
' it's COM1 or COM3, or COM2 or COM4.  If other tests indicate that one
' of the particular COM ports doesn't exist, it is then narrowed down
' further.
'
IF COMP$<>"PS/2" THEN
'
'  Interrupt 33 / subfunction AL = 0 (all calls to interrupt 33 use
' function AH = 0) returns information indicating whether a mouse driver
' is installed, and if so, how many buttons the mouse has.
'
INREGS.AX=0
CALL INTERRUPTX(&H33,INREGS,OUTREGS)
IF OUTREGS.AX=&HFFFF THEN
'
'  The mouse exists.  Get driver location and query it to see where mouse
' is.
'
NBUT$=LTRIM$(RTRIM$(STR$(OUTREGS.BX)))
'
'  Interrupt 21 / function 35 returns address of interrupt routines.
' (In this case, interrupt 33 is the mouse driver.)
'
INREGS.AX=&H3533
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
'
'  Point basic to location of mouse driver.
'
DEF SEG=OUTREGS.ES
'
'  For Mouse Systems driver, COM interrupt is stored at an offset of 18h
' into the driver.  If the mouse is on COM1 or COM3, this interrupt will
' be C (hex).  For COM2/COM4, it will be Bh.
'
MINTRP=PEEK(OUTREGS.BX+18)
MCOM$="unidentifiable port"
IF MINTRP=11 THEN MCOM$="COM2 or COM4"
IF MINTRP=12 THEN MCOM$="COM1 or COM3"
IF MCOM$="unidentifiable port" THEN
'
'  Driver either isn't from Mouse Systems or else it's of some different
' version than assumed here.  Use other information to try and "second-
' guess" where the rodent is.
'
IF COM1ADD<>0 AND COM2ADD=0 THEN MCOM$="COM1 or COM3"
IF COM1ADD=0 AND COM2ADD<>0 THEN MCOM$="COM2 or COM4"
END IF
'
'  Try to use other information to narrow down mouse location.
'
IF MCOM$="COM1 or COM3" THEN IF COM3D>-1 THEN MCOM$="COM1"
IF MCOM$="COM1 or COM3" THEN IF COM1ADD=0 THEN MCOM$="COM3"
IF MCOM$="COM2 or COM4" THEN IF COM4D>-1 THEN MCOM$="COM2"
IF MCOM$="COM2 or COM4" THEN IF COM2ADD=0 THEN MCOM$="COM4"
PRINT NBUT$;"-button mouse installed via interrupt 33h on ";MCOM$
PRINT
END IF
END IF
'
'  Use interrupt 21 / function 52 to find out how many "block devices"
' are present.
'
INREGS.AX=&H5200
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
DEF SEG=OUTREGS.ES
NBLOCK=PEEK(OUTREGS.BX+&H20)
PRINT LTRIM$(RTRIM$(STR$(NBLOCK)));" block devices (disk drives) detected"
PRINT
'
'  Find out if MSHERC is installed and also output video mode that existed
' before this program was called.
'
INREGS.AX=&HEF00
INREGS.DX=0
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
IF OUTREGS.DX<>0 THEN PRINT "MSHERC detected" : PRINT
PRINT "Current bios video mode = ";HEX$(CMODE);"h"
'
'  Use interrupt 2F / function 15 / subfunction 0 to detect MSCDEX.EXE
' and report number of CD-ROMs it is supporting.
'
INREGS.AX=&H1500
INREGS.BX=0
CALL INTERRUPTX(&H2F,INREGS,OUTREGS)
IF OUTREGS.BX>0 THEN
PRINT
PRINT LTRIM$(RTRIM$(STR$(OUTREGS.BX)));" CD-ROM drives detected starting with ";
PRINT CHR$(65+OUTREGS.CX)
END IF
ELSE
PRINT
PRINT "  You're using DOS 1.  Most of the functionallity of this program won't"
PRINT "work with your operating system."
END IF
PRINT
PRINT
'
'  If SCREEN 0 statement, above, changed video mode, put screen back into
' CMODE.
'
IF NEWMODE<>CMODE THEN
PRINT "Press a key to continue...";
30 IF INKEY$="" THEN GOTO 30
PRINT
INREGS.AX=CMODE
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  Don't use QB END statement to terminate.  (It may change video mode.)
'  Use interrupt 21 / function 4C instead.
'
INREGS.AX=&H4C00
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
END IF
END
'
'  This subroutine returns the BAUD, parity (PAR$), data bit (DBITS), and
' stop bit (SBITS) setting for the COM port specified by address PORT.  If
' DBITS is returned as 5 and SBITS as 2, SBITS should be interpreted by
' the calling routine as 1.5.  (It would not be a good idea to input
' invalid values for PORT.)
'
SUB UART(PORT AS INTEGER,BAUD,PAR$,DBITS,SBITS)
DIM DTAB(3),PARTAB$(7),LCR AS INTEGER
'
'  Set up tables.
'
DTAB(0)=5 : DTAB(1)=6 : DTAB(2)=7 : DTAB(3)=8
PARTAB$(0)="IGNORE" : PARTAB$(4)="ODD" : PARTAB$(5)="MARK" : PARTAB$(6)="EVEN"
PARTAB$(7)="SPACE" : PARTAB$(1)="ODD" : PARTAB$(2)="EVEN" : PARTAB$(3)="EVEN"
'
'  Get contents of Line Control Register and convert it to binary.
'
LCR=INP(PORT+3)
B$=BIN$(CLNG(LCR))
'
'  Bits 0 and 1 give number of data bits.
'
DBITS=DTAB(DEC(MID$(B$,15,2)))
'
'  Bit 2 gives number of stop bits.
'
SBITS=VAL(MID$(B$,14,1))+1
'
'  Bits 3, 4, and 5 give parity information.
'
PAR$=PARTAB$(DEC(MID$(B$,11,3)))
'
'  Set bit 7 of LCR to 1 so baud can be determined.
'
LCR=LCR OR 128%
OUT PORT+3,LCR
'
'  Get "Baud Rate Divisor" and reset bit 7 of LCR to 0.
'
BRD=INP(PORT)+256*INP(PORT+1)
LCR=LCR AND 127%
OUT PORT+3,LCR
'
'  Get BAUD and return.
'
BAUD=CINT(115200!/BRD+.001)
END SUB
'
'  This is a "functionized" version of code extracted from a more general
' numeric base conversion program by Robert B. Relf, (C) 1984.  This just
' uses the part of Mr. Relf's code that converts decimal to binary.
'
FUNCTION BIN$(NUM AS LONG)
DIM X AS INTEGER,NUM1 AS LONG
NUM1=(NUM+65536&) MOD 65536&
BIN1$=""
FOR X=15 TO 0 STEP -1
IF NUM1>=(2^X) THEN
BIN1$=BIN1$+"1"
NUM1=NUM1-(2^X)
ELSE
BIN1$=BIN1$+"0"
END IF
NEXT X
BIN1$=LEFT$(BIN1$,8)+RIGHT$(BIN1$,8)
BIN$=BIN1$
END FUNCTION
'
'  This function inputs a string representing a binary number and converts
' it to a decimal number.
'
FUNCTION DEC%(B AS STRING)
DIM V AS LONG
N=LEN(B)
V=0
FOR I=1 TO N
V=V+2&^(I-1)*VAL(MID$(B,N-I+1,1))
NEXT I
DEC=CINT(V)
END FUNCTION
